﻿using UnityEngine;
using UnityEditor;
using System.Collections;
using FullControl.Tx.View;
using FullControl.Tx.LevelEditor;

[CustomEditor(typeof(SpawnAsset))]
public class SpawnAssetEditor : AssetViewEditor 
{

	SerializedProperty unitFaction;
	SerializedProperty unitId;
	SerializedProperty triggers;
	SerializedProperty npcName;
	SpawnAsset spawnAsset;
	bool triggersOpen = true;

	protected override void OnEnable ()
	{
		base.OnEnable();
		
		//SpawnAsset ga = target as SpawnAsset;
		
		//unitFaction = serializedObject.FindProperty("faction");
		unitId = serializedObject.FindProperty("unitID");
		triggers = serializedObject.FindProperty("onClickTriggers");
		npcName = serializedObject.FindProperty("npcName");

		spawnAsset = target as SpawnAsset;

	}

	protected override void OnSceneInspectorGUI ()
	{
		base.OnSceneInspectorGUI ();
		EditorGUILayout.PropertyField(unitId, new GUIContent("UnitId"));

		EditorGUI.indentLevel += 5;
		EditorGUILayout.HelpBox("Leave blank for random", MessageType.None);
		EditorGUI.indentLevel -= 5;

		if (spawnAsset.faction == FullControl.Tx.Entities.Units.UnitFaction.None)
		{
			EditorGUILayout.PropertyField(npcName, new GUIContent("NPC name"));

			EditorGUI.indentLevel += 5;
			EditorGUILayout.HelpBox("You must provide a name if the unitID is left blank", MessageType.None);
			EditorGUI.indentLevel -= 5;
			
			triggersOpen = EditorHelper.ArreayEditor(triggers, "OnClick triggers", triggersOpen, TriggerItemEditor);
			serializedObject.ApplyModifiedProperties();
		}



	}

	private void TriggerItemEditor (SerializedProperty item)
	{
		TriggerEditor.BaseTriggerEditor(item.FindPropertyRelative("enabled"), item.FindPropertyRelative("runOnlyOnce"), item.FindPropertyRelative("conditionScript"), item.FindPropertyRelative("effectScript"));
	}
}
